﻿Imports System.Data.SqlClient
Imports CrystalDecisions.CrystalReports.Engine
Imports CrystalDecisions.Shared
Public Class frmPendingApproval
    Dim rpt As New rptPendingApproval()
    Dim deptDs As New DataSet
    Dim deptDa As SqlDataAdapter
    Dim deptCodeArray(500) As String
    Dim ReqStockCount As Integer
    Private Sub frmPendingApproval_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            Call Db_Connection()
            ReqStockCount = Val(txtStocCount.Text)
            If ReqStockCount = 0 Then
                ds.Reset()
                sql = "SELECT convert(varchar,A.SRQ_DATE, 103) AS DATE, A.SRQ_ITEMCODE, A.SRQ_QTY, A.SRQ_REMARK, convert(varchar,A.SRQ_ITEMBEFORE,103) AS BEFORE_DATE, (CASE WHEN (A.SRQ_STATUS >=1) THEN 'Aproved' ELSE 'Pending' END)AS STATUS, B.USR_EMPNAME, C.DEPT_DEPTNAME, D.ITM_ITEMDESC FROM STOCK_REQUEST AS A LEFT JOIN USER_MASTER AS B ON B.USR_EMPID=A.SRQ_REQUESTBY LEFT JOIN DEPARTMENT AS C ON C.DEPT_DEPTID = B.USR_DEPTID LEFT JOIN ITEMS AS D ON D.ITM_ITEMCODE = A.SRQ_ITEMCODE WHERE A.IS_DELETE=0 AND A.SRQ_STATUS <> 4 AND A.SRQ_STATUS <> 2 "
                da = New SqlDataAdapter(sql, Mycn)
                da.Fill(ds, DBNAME)

                rpt.SetDataSource(ds.Tables(DBNAME))
            Else
                ds.Reset()
                sql = "SELECT TOP " & ReqStockCount & " convert(varchar,A.SRQ_DATE, 103) AS DATE, A.SRQ_ITEMCODE, A.SRQ_QTY, A.SRQ_REMARK, convert(varchar,A.SRQ_ITEMBEFORE,103) AS BEFORE_DATE, B.USR_EMPNAME,(CASE WHEN (A.SRQ_STATUS =0) THEN '' END)AS STATUS, C.DEPT_DEPTNAME, D.ITM_ITEMDESC FROM STOCK_REQUEST AS A LEFT JOIN USER_MASTER AS B ON B.USR_EMPID=A.SRQ_REQUESTBY LEFT JOIN DEPARTMENT AS C ON C.DEPT_DEPTID = B.USR_DEPTID LEFT JOIN ITEMS AS D ON D.ITM_ITEMCODE = A.SRQ_ITEMCODE WHERE A.SRQ_STATUS = 0 AND A.IS_DELETE=0 ORDER BY A.ID DESC "
                da = New SqlDataAdapter(sql, Mycn)
                da.Fill(ds, DBNAME)

                rpt.SetDataSource(ds.Tables(DBNAME))

                Dim objStatus As TextObject = DirectCast(rpt.ReportDefinition.Sections("Section2").ReportObjects("Text3"), TextObject)
                objStatus.Text = ""
            End If

            Dim objCompany As TextObject = DirectCast(rpt.ReportDefinition.Sections("Section2").ReportObjects("txtrptCompany"), TextObject)
            objCompany.Text = LGNCOMPNAME
            Dim objAddress As TextObject = DirectCast(rpt.ReportDefinition.Sections("Section2").ReportObjects("txtrptAddress"), TextObject)
            objAddress.Text = LGNCMPADDRESS
            CrystalReportViewer1.ReportSource = rpt
            
            LoadDepartment()
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub

    Private Sub btnGetDetails_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetDetails.Click
        Try
            Dim deptCode As String

            If cmbDepartment.SelectedIndex = -1 Then
                deptCode = ""
            Else
                deptCode = "AND C.DEPT_DEPTID = '" & deptCodeArray(cmbDepartment.SelectedIndex) & "'"
            End If

            ds.Reset()
            sql = "SELECT convert(varchar,A.SRQ_DATE, 103) AS DATE, A.SRQ_ITEMCODE, A.SRQ_QTY, A.SRQ_REMARK, convert(varchar,A.SRQ_ITEMBEFORE,103) AS BEFORE_DATE, (CASE WHEN (A.SRQ_STATUS >=1) THEN 'Aproved' ELSE 'Pending' END)AS STATUS, B.USR_EMPNAME, C.DEPT_DEPTNAME, D.ITM_ITEMDESC FROM STOCK_REQUEST AS A LEFT JOIN USER_MASTER AS B ON B.USR_EMPID=A.SRQ_REQUESTBY LEFT JOIN DEPARTMENT AS C ON C.DEPT_DEPTID = B.USR_DEPTID LEFT JOIN ITEMS AS D ON D.ITM_ITEMCODE = A.SRQ_ITEMCODE WHERE A.IS_DELETE=0 AND A.SRQ_STATUS <> 4 " & deptCode & " AND A.SRQ_DATE BETWEEN '" & dtpFromDate.Value.ToString("MM/dd/yyyy") & "' AND '" & dtpToDate.Value.ToString("MM/dd/yyyy") & "' "
            da = New SqlDataAdapter(sql, Mycn)
            da.Fill(ds, DBNAME)

            rpt.SetDataSource(ds.Tables(DBNAME))

            CrystalReportViewer1.ReportSource = rpt
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try


    End Sub


    Private Sub LoadDepartment()

        Try

            'LOAD DEPARTMENT
            sql = " SELECT DEPT_DEPTID, DEPT_DEPTNAME, CREATED_DATE FROM DEPARTMENT WHERE IS_DELETE = 0 "
            deptDa = New SqlDataAdapter(sql, Mycn)
            deptDa.Fill(deptDs, DBNAME)
            Dim rowCount = deptDs.Tables(DBNAME).Rows.Count
            cmbDepartment.Items.Clear()
            For i = 0 To rowCount - 1
                deptCodeArray(i) = deptDs.Tables(DBNAME).Rows(i).Item(0)
                cmbDepartment.Items.Add(deptDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub

End Class